<?php
namespace Import\ApiBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class AllegroImportCategoryItemsCommand extends ContainerAwareCommand
{
    private $Container;
    private $input;
    private $output;

    protected function configure()
    {
        $this
            ->setName('import:allegro:category:items')
            ->setDescription('Import Items fpr Category from allegro.pl')
            ->addArgument('duration', null, InputOption::VALUE_OPTIONAL, 'Last add items?', null)
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $timeStart = new \DateTime();
        $this->input = $input;
        $this->output = $output;
        $this->Container = $this->getContainer();
        $duration = ($input->getArgument('duration') == null) ? null : (int)$input->getArgument('duration');

        $this->executeFunction('allegroImportCategoryItems',$duration);

        $timeEnd = new \DateTime();
        $time = $timeEnd->getTimestamp() - $timeStart->getTimestamp();
        $output->writeln('Total time: '.$time.'s');
    }

    private function executeFunction($functionName, $param)
    {
        $start = new \DateTime();
        $this->output->write('<info>'.$functionName.'</info> - ');
        $res = $this->$functionName($param);
        $end = new \DateTime();
        $this->output->writeln('OK (count='.$res['count'].') - '.($end->getTimestamp() - $start->getTimestamp()).'s');
    }

    private function allegroImportCategoryItems($duration)
    {
        $allegroImportCategoryItems = $this->Container->get('allegro_web_api_import_category_items');
        return $allegroImportCategoryItems->import($duration);
    }
}